/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.massStorage;

import jace.hardware.massStorage.DiskNode;
import jace.hardware.massStorage.ProdosVirtualDisk;
import jace.hardware.massStorage.SubNode;
import java.io.IOException;

public class FreespaceBitmap
extends DiskNode {
    int size = (ProdosVirtualDisk.MAX_BLOCK + 1) / 8 / ProdosVirtualDisk.BLOCK_SIZE;

    public FreespaceBitmap(ProdosVirtualDisk fs, int start) throws IOException {
        this.setBaseBlock(start);
        this.setOwnerFilesystem(fs);
        for (int i = 1; i < this.size; ++i) {
            new SubNode(i, this, start + i);
        }
    }

    public void doDeallocate() {
    }

    public void doAllocate() {
    }

    public void doRefresh() {
    }

    public void readBlock(int sequence, byte[] buffer) throws IOException {
        int startBlock = sequence * ProdosVirtualDisk.BLOCK_SIZE * 8;
        int endBlock = (sequence + 1) * ProdosVirtualDisk.BLOCK_SIZE * 8;
        int bitCounter = 0;
        int pos = 0;
        int value = 0;
        for (int i = startBlock; i < endBlock; ++i) {
            if (!this.getOwnerFilesystem().isAllocated(i)) {
                ++value;
            }
            if (++bitCounter < 8) {
                value *= 2;
                continue;
            }
            bitCounter = 0;
            buffer[pos++] = (byte)value;
            value = 0;
        }
    }
}

